#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

######################################################################################################################
# script to generate syslog-ng relative configurations,
#
#   - native log    | /etc/syslog-ng/syslog.conf                    | always enable
#   - Synology log  | /etc/syslog-ng/patterndb.d/synolog.conf       | always enable
#   - Log accounting| /etc/syslog-ng/patterndb.d/syslog-acc.conf    | always enable
#   - Syslog Client | /etc/syslog-ng/patterndb.d/syslog-client.conf | control by "client" option of this script
#   - BSD Server    | /etc/syslog-ng/patterndb.d/syslog-bsd.conf    | control by "bsd" option of this script
#   - IETF Server   | /etc/syslog-ng/patterndb.d/syslog-ietf.conf   | control by "ietf" option of this script
#   - Archive       | /etc/syslog-ng/patterndb.d/syslog-archive.conf| control by "localarch" option of this script
#
######################################################################################################################

SYSLOGNG_CONFIG_FOLDER=/etc/syslog-ng/patterndb.d
SYSLOGNG_CONFIG_COMMON=${SYSLOGNG_CONFIG_FOLDER}/common.conf
SYSLOGNG_CONFIG_ACCOUNTING=${SYSLOGNG_CONFIG_FOLDER}/syslog-acc.conf
SYSLOGNG_CONFIG_CLIENT=${SYSLOGNG_CONFIG_FOLDER}/syslog-client.conf
SYSLOGNG_CONFIG_BSD=${SYSLOGNG_CONFIG_FOLDER}/syslog-bsd.conf
SYSLOGNG_CONFIG_IETF=${SYSLOGNG_CONFIG_FOLDER}/syslog-ietf.conf
SYSLOGNG_CONFIG_ARCHIVE=${SYSLOGNG_CONFIG_FOLDER}/syslog-archive.conf
SYSLOGNG_CONFIG_NOTIFICATION=${SYSLOGNG_CONFIG_FOLDER}/syslog-notification.conf
SYSLOGNG_CONFIG_CUSTRULE=${SYSLOGNG_CONFIG_FOLDER}/syslog-custrule.conf

SYSLOGNG_CLIENT_SETTING=/etc/synosyslog/client.conf
SYSLOGNG_SERVER_SETTING=/etc/synosyslog/server.conf
SYSLOGNG_NOTIFY_SETTING=/etc/synosyslog/notify.conf
SYSLOGNG_CUSTRULE_SETTING=/etc/synosyslog/custrule.conf

SYSLOGNG_ARCHIVE_TEMPLATE_FOLDER=/usr/syno/syslog/etc/template/archive
SYSLOGNG_CLIENT_TEMPLATE_FOLDER=/usr/syno/syslog/etc/template/client
SYSLOGNG_SERVER_TEMPLATE_FOLDER=/usr/syno/syslog/etc/template/server
SYSLOGNG_CUSTRULE_TEMPLATE_FOLDER=/usr/syno/syslog/etc/template/custrule

SYSLOGNG_SCRIPT_FOLDER=/usr/syno/syslog/scripts/service
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_common.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_acc_util.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_client_util.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_server_util.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_localarch_util.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_notification.sh
. ${SYSLOGNG_SCRIPT_FOLDER}/syslog_custrule_util.sh

Usage(){
    echo "Usage: $0 (acc|client|bsd|ietf|localarch|notification|custrule) (confgen|confclr)"
}

case $1 in
    acc)
        case $2 in
            confgen)
                SyslogAccountingConfigGen
            ;;
            confclr)
                SyslogAccountingConfigClr
            ;;
            reload)
                SyslogAccountingReload
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    client)
        case $2 in
            confgen)
                SyslogClientConfigGen
            ;;
            confclr)
                SyslogClientConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    bsd)
        case $2 in
            confgen)
                SyslogBsdConfigGen
            ;;
            confclr)
                SyslogBsdConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    ietf)
        case $2 in
            confgen)
                SyslogIetfConfigGen
            ;;
            confclr)
                SyslogIetfConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    localarch)
        case $2 in
            confgen)
                SyslogLocalarchConfigGen
            ;;
            confclr)
                SyslogLocalarchConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    notification)
        case $2 in
            confgen)
                SyslogNotificationConfigGen
            ;;
            confclr)
                SyslogNotificationConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    custrule)
        case $2 in
            confgen)
                SyslogCustruleConfigGen
            ;;
            confclr)
                SyslogCustruleConfigClr
            ;;
            *)
                Usage
            ;;
        esac
    ;;
    *)
        Usage
    ;;
esac

